/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.common.util;

import com.xuanwu.mos.common.entity.MediaItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaUtil {
    private static final int MAX_ACCEPT_FILE_LENGTH = 0x100000;

    public static MediaItem getMediaFromFile(String folder, String fileName) throws IOException {
        File file = new File(folder, fileName);
        return MediaUtil.getMediaFromFile(file);
    }

    public static MediaItem getMediaFromFile(String fullFileName) throws IOException {
        File file = new File(fullFileName);
        return MediaUtil.getMediaFromFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaItem getMediaFromFile(File file) throws IOException {
        MediaItem mediaItem;
        block5: {
            int fileLen;
            FileInputStream fis;
            block3: {
                MediaItem mediaItem2;
                block4: {
                    fis = new FileInputStream(file);
                    try {
                        fileLen = fis.available();
                        if (fileLen <= 0x100000) break block3;
                        mediaItem2 = null;
                        Object var7_5 = null;
                        if (fis == null) break block4;
                    }
                    catch (Throwable throwable) {
                        block6: {
                            Object var7_7 = null;
                            if (fis == null) break block6;
                            fis.close();
                        }
                        throw throwable;
                    }
                    fis.close();
                }
                return mediaItem2;
            }
            byte[] data = new byte[fileLen];
            fis.read(data);
            MediaItem media = new MediaItem();
            media.setData(data);
            media.setMeta(file.getName());
            mediaItem = media;
            Object var7_6 = null;
            if (fis == null) break block5;
            fis.close();
        }
        return mediaItem;
    }

    public static List<MediaItem> getMediasFromFolder(String path) throws IOException {
        File folder = new File(path);
        if (!folder.exists()) {
            throw new FileNotFoundException(path);
        }
        if (!folder.isDirectory()) {
            throw new IOException(path + " : is not a folder?!");
        }
        ArrayList<MediaItem> medias = new ArrayList<MediaItem>();
        for (File file : folder.listFiles()) {
            MediaItem media;
            if (!file.isFile() || (media = MediaUtil.getMediaFromFile(file)) == null) continue;
            medias.add(media);
        }
        return medias;
    }
}

