/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.common.util.http;

import com.xuanwu.mos.common.util.StringUtils;
import com.xuanwu.mos.common.util.http.HttpResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_GET = "GET";
    private static final String ACCEPT_MEDIA_TYPE = "text/plain,text/html,text/xml,application/xml,application/json";
    private static SSLContext ctx = null;
    private static SSLSocketFactory socketFactory = null;
    private static HostnameVerifier verifier = null;

    private WebUtils() {
    }

    private static HttpURLConnection getConnection(URL url, String method, Map<String, String> headers, int connTimeout, int readTimeout) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(socketFactory);
            connHttps.setHostnameVerifier(verifier);
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setConnectTimeout(connTimeout);
        conn.setReadTimeout(readTimeout);
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    public static HttpResponse doGet(String url, Map<String, String> params) throws IOException {
        return WebUtils.doGet(url, params, DEFAULT_CHARSET, 0, 0);
    }

    public static HttpResponse doGet(String url, Map<String, String> params, int connTimeout) throws IOException {
        return WebUtils.doGet(url, params, DEFAULT_CHARSET, connTimeout, 0);
    }

    public static HttpResponse doGet(String url, Map<String, String> params, int connTimeout, int readTimeout) throws IOException {
        return WebUtils.doGet(url, params, DEFAULT_CHARSET, connTimeout, readTimeout);
    }

    public static HttpResponse doGet(String url, Map<String, String> params, String charset, int connTimeout, int readTimeout) throws IOException {
        HttpURLConnection conn = null;
        HttpResponse response = null;
        try {
            String contentType = "application/x-www-form-urlencoded;charset=" + charset;
            String query = WebUtils.buildQuery(params, charset);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", ACCEPT_MEDIA_TYPE);
            headers.put("User-Agent", "SDK_JAVA5.1");
            headers.put("Content-Type", contentType);
            conn = WebUtils.getConnection(WebUtils.buildGetUrl(url, query), METHOD_GET, headers, connTimeout, readTimeout);
            String content = WebUtils.getResponseAsString(conn);
            response = new HttpResponse(conn.getResponseCode(), conn.getContentType(), conn.getContentLength(), content);
            Object var12_12 = null;
            if (conn != null) {
                conn.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (conn != null) {
                conn.disconnect();
            }
            throw throwable;
        }
        return response;
    }

    public static HttpResponse doPost(String url, Map<String, String> params, int connectTimeout, int readTimeout) throws IOException {
        String contentType = "application/x-www-form-urlencoded;charset=UTF-8";
        String query = WebUtils.buildQuery(params, DEFAULT_CHARSET);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(DEFAULT_CHARSET);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", ACCEPT_MEDIA_TYPE);
        headers.put("User-Agent", "SDK_JAVA5.1");
        headers.put("Content-Type", contentType);
        return WebUtils.doPost(url, headers, content, connectTimeout, readTimeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpResponse doPost(String url, Map<String, String> headers, byte[] content, int connectTimeout, int readTimeout) throws IOException {
        HttpResponse response;
        HttpURLConnection conn;
        block7: {
            conn = null;
            OutputStream out = null;
            response = null;
            try {
                conn = WebUtils.getConnection(new URL(url), METHOD_POST, headers, connectTimeout, readTimeout);
                out = conn.getOutputStream();
                if (content != null) {
                    out.write(content);
                }
                String body = WebUtils.getResponseAsString(conn);
                response = new HttpResponse(conn.getResponseCode(), conn.getContentType(), conn.getContentLength(), body);
                Object var10_10 = null;
                if (out == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (out != null) {
                    out.close();
                }
                if (conn == null) throw throwable;
                conn.disconnect();
                throw throwable;
            }
            out.close();
        }
        if (conn == null) return response;
        conn.disconnect();
        return response;
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isEmpty(name) || StringUtils.isEmpty(value)) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    private static URL buildGetUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (query == null || query.length() == 0) {
            return url;
        }
        strUrl = StringUtils.isEmpty(url.getQuery()) ? (strUrl.endsWith("?") ? strUrl + query : strUrl + "?" + query) : (strUrl.endsWith("&") ? strUrl + query : strUrl + "&" + query);
        return new URL(strUrl);
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        InputStream input = conn.getErrorStream();
        if (input == null) {
            return WebUtils.getStreamAsString(conn.getInputStream(), DEFAULT_CHARSET);
        }
        String msg = WebUtils.getStreamAsString(input, DEFAULT_CHARSET);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        String string;
        block3: {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
                StringWriter writer = new StringWriter();
                char[] chars = new char[256];
                int count = 0;
                while ((count = reader.read(chars)) > 0) {
                    writer.write(chars, 0, count);
                }
                string = writer.toString();
                Object var8_7 = null;
                if (stream == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_8 = null;
                    if (stream == null) break block4;
                    stream.close();
                }
                throw throwable;
            }
            stream.close();
        }
        return string;
    }

    static {
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            ctx.getClientSessionContext().setSessionTimeout(15);
            ctx.getClientSessionContext().setSessionCacheSize(1000);
            socketFactory = ctx.getSocketFactory();
            verifier = new HostnameVerifier(){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

