/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.config;

import com.xuanwu.mos.PostMsg;
import com.xuanwu.mos.ams.AmsMonitor;
import com.xuanwu.mos.common.log.PostMsgLogger;
import com.xuanwu.mos.config.PostMsgConfig;
import com.xuanwu.mos.config.PostMsgConfigReader;
import com.xuanwu.mos.ha.HAMonitor;
import com.xuanwu.mos.profiles.UserProfilesService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConfigControlCenter {
    private static volatile boolean initialize = false;
    private static final int RELOAD_INTERVAL_SECONDS = 20;
    private static boolean stopReloadConfig = false;
    private static Lock configLoadLock = new ReentrantLock();
    private static PostMsg postMsg;
    public static volatile String accountName;

    public static synchronized void initialize(PostMsg postMsg) {
        ConfigControlCenter.postMsg = postMsg;
        if (PostMsg.isHighAvailability()) {
            HAMonitor haMonitor = HAMonitor.getInstance();
            haMonitor.setInitMtServer(ConfigControlCenter.postMsg.getGwHost());
            haMonitor.setInitMoServer(ConfigControlCenter.postMsg.getWsHost());
            PostMsg.setHaMonitor(haMonitor);
        }
        if (initialize) {
            return;
        }
        ConfigControlCenter.onConfigLoad();
        if (!stopReloadConfig) {
            ConfigControlCenter.startConfigReloadThread();
        }
        initialize = true;
    }

    private static void startConfigReloadThread() {
        Thread reloadConfigThread = new Thread(){

            public void run() {
                while (!stopReloadConfig) {
                    try {
                        TimeUnit.SECONDS.sleep(20L);
                        PostMsgConfigReader.reloadProperties();
                        ConfigControlCenter.onConfigLoad();
                    }
                    catch (Exception e) {
                        PostMsgLogger.logError("ConfigControlCenter: realod config error: " + e.getMessage());
                    }
                }
            }
        };
        reloadConfigThread.setName("PostMsg Config Reload");
        reloadConfigThread.setDaemon(true);
        reloadConfigThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onConfigLoad() {
        if (configLoadLock.tryLock()) {
            try {
                ConfigControlCenter.settingLogger();
                ConfigControlCenter.settingFetchUserProfiles();
                ConfigControlCenter.settingHighAvailability();
                ConfigControlCenter.settingMonitor();
                Object var1 = null;
                configLoadLock.unlock();
            }
            catch (Throwable throwable) {
                Object var1_1 = null;
                configLoadLock.unlock();
                throw throwable;
            }
        }
    }

    private static void settingLogger() {
        try {
            if (PostMsgConfig.isLoggerEnable()) {
                PostMsgLogger.setEnableLogger(true);
            } else {
                PostMsgLogger.setEnableLogger(false);
            }
            if (PostMsgConfig.isBizLoggerEnable()) {
                PostMsgLogger.setEnableBizLogger(true);
            } else {
                PostMsgLogger.setEnableBizLogger(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void settingFetchUserProfiles() {
        UserProfilesService inst = UserProfilesService.getInstance();
        try {
            if (PostMsgConfig.isUserProfilesEnable()) {
                if (!inst.isStopFetch()) {
                    return;
                }
                inst.startFetchThread();
            } else {
                if (inst.isStopFetch()) {
                    return;
                }
                inst.stopFetchThread();
            }
        }
        catch (Exception e) {
            PostMsgLogger.logError("Read config: user profiles error: " + e.getMessage());
        }
    }

    private static void settingHighAvailability() {
        HAMonitor haMonitor = HAMonitor.getInstance();
        try {
            if (PostMsgConfig.isHighAvailabilityEnable()) {
                if (PostMsg.isHighAvailability()) {
                    return;
                }
                PostMsgLogger.logInfo("Starting enable high availability function ...");
                haMonitor.setInitMtServer(postMsg.getGwHost());
                haMonitor.setInitMoServer(postMsg.getWsHost());
                haMonitor.startMonitor();
                PostMsg.setHaMonitor(haMonitor);
                PostMsg.setHighAvailability(true);
                PostMsgLogger.logInfo("High availability function enabled");
            } else {
                if (!PostMsg.isHighAvailability()) {
                    return;
                }
                PostMsgLogger.logInfo("Starting disable high availability function ...");
                haMonitor.closeMonitor();
                PostMsg.setHaMonitor(null);
                PostMsg.setHighAvailability(false);
                PostMsgLogger.logInfo("High availability function disabled");
            }
        }
        catch (Exception e) {
            PostMsgLogger.logError("Read config: high availability error: " + e.getMessage());
        }
    }

    private static void settingMonitor() {
        try {
            if (PostMsgConfig.isMonitorEnable()) {
                AmsMonitor.setMonitoring(true);
            } else {
                AmsMonitor.setMonitoring(false);
            }
        }
        catch (Exception e) {
            PostMsgLogger.logError("Read config: performance monitor error: " + e.getMessage());
        }
    }

    public static boolean isStopReloadConfig() {
        return stopReloadConfig;
    }

    public static void setStopReloadConfig(boolean stopReloadConfig) {
        ConfigControlCenter.stopReloadConfig = stopReloadConfig;
    }

    static {
        accountName = null;
        boolean success = PostMsgConfigReader.reloadProperties();
        if (!success) {
            stopReloadConfig = true;
        }
    }
}

