/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.ha;

import com.xuanwu.mos.HostInfo;
import com.xuanwu.mos.common.util.StringUtils;
import com.xuanwu.mos.profiles.UserProfiles;
import com.xuanwu.mos.profiles.UserProfilesListener;
import com.xuanwu.mos.profiles.UserProfilesService;
import com.xuanwu.mos.profiles.ha.HaAttributes;
import com.xuanwu.mos.profiles.ha.HighAvailability;
import com.xuanwu.mos.profiles.ha.MoServer;
import com.xuanwu.mos.profiles.ha.MoServerAttributes;
import com.xuanwu.mos.profiles.ha.MoServerConfig;
import com.xuanwu.mos.profiles.ha.MtServer;
import com.xuanwu.mos.profiles.ha.MtServerAttributes;
import com.xuanwu.mos.profiles.ha.MtServerConfig;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class HAMonitor
implements UserProfilesListener {
    private List<HostInfo> mtHostList = new LinkedList<HostInfo>();
    private List<HostInfo> failureMtHostList = new LinkedList<HostInfo>();
    private List<HostInfo> moHostList = new LinkedList<HostInfo>();
    private List<HostInfo> failureMoHostList = new LinkedList<HostInfo>();
    private ReentrantLock mtHostLock = new ReentrantLock();
    private ReentrantLock moHostLock = new ReentrantLock();
    private static final int DEFAULT_MARK_POSITION = -1;
    private int markMtHostPosition = -1;
    private int markMoHostPosition = -1;
    private Thread serverInspector;
    private volatile boolean stopServerInspector = true;
    private volatile long checkFailureServerInterval = 20L;
    private static final int CHECK_SERVER_TIMEOUT = 5000;
    private HostInfo initMtServer;
    private HostInfo initMoServer;
    private volatile int mtTrySwitchTimes = 0;
    private volatile int moTrySwitchTimes = 0;

    public static HAMonitor getInstance() {
        return HAMonitorHolder.INSTANCE;
    }

    private HAMonitor() {
    }

    public synchronized void startMonitor() {
        if (!this.stopServerInspector) {
            return;
        }
        this.serverInspector = new Thread(){

            public void run() {
                while (!HAMonitor.this.stopServerInspector) {
                    try {
                        TimeUnit.SECONDS.sleep(HAMonitor.this.checkFailureServerInterval);
                        HAMonitor.this.checkMtAndMoServer();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        };
        this.stopServerInspector = false;
        this.serverInspector.setName("MT&MO Server Inspector");
        this.serverInspector.setDaemon(true);
        this.serverInspector.start();
        UserProfilesService.addUserProfilesListener(this);
    }

    public synchronized void closeMonitor() {
        if (this.stopServerInspector) {
            return;
        }
        try {
            this.serverInspector.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        UserProfilesService.removeUserProfilesListener(this);
        this.stopServerInspector = true;
    }

    public void notifyWhenRefresh() {
        try {
            this.configMtAndMoServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void configMtAndMoServer() throws Exception {
        UserProfiles userProfiles = UserProfilesService.getUserProfiles();
        if (userProfiles == null || userProfiles.getHighAvailability() == null) {
            return;
        }
        HighAvailability ha = userProfiles.getHighAvailability();
        this.configMtServer(ha.getMtServerConfig());
        this.configMoServer(ha.getMoServerConfig());
        HaAttributes attr = ha.getAttributes();
        if (attr != null && attr.getCheckFailureServerInterval() > 0) {
            this.checkFailureServerInterval = attr.getCheckFailureServerInterval();
        }
        if (this.markMtHostPosition == -1 && this.initMtServer != null) {
            for (HostInfo mtServer : this.mtHostList) {
                if (!mtServer.equals(this.initMtServer)) continue;
                this.initMtServer.setRetryTimes(mtServer.getRetryTimes());
                this.initMtServer.setRetryInterval(mtServer.getRetryInterval());
                break;
            }
        }
        if (this.markMoHostPosition == -1 && this.initMoServer != null) {
            for (HostInfo moServer : this.moHostList) {
                if (!moServer.equals(this.initMoServer)) continue;
                this.initMoServer.setRetryTimes(moServer.getRetryTimes());
                this.initMoServer.setRetryInterval(moServer.getRetryInterval());
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configMtServer(MtServerConfig config) throws Exception {
        List<MtServer> servers;
        if (config == null) {
            return;
        }
        MtServerAttributes attributes = config.getAttributes();
        if (attributes != null && attributes.getTrySwitchTimes() >= 0) {
            this.mtTrySwitchTimes = attributes.getTrySwitchTimes();
        }
        if ((servers = config.getMtServers()) == null) {
            return;
        }
        ArrayList<HostInfo> tempMtHostList = new ArrayList<HostInfo>();
        this.mtHostLock.lock();
        try {
            for (MtServer server : servers) {
                String ip = server.getIp();
                int port = server.getPort();
                if (StringUtils.isBlank(ip) || port < 0 || port > 65535) continue;
                HostInfo readyToAddHost = new HostInfo(ip, port);
                readyToAddHost.setRetryTimes(server.getRetryTimes());
                readyToAddHost.setRetryInterval(server.getRetryInterval());
                tempMtHostList.add(readyToAddHost);
                boolean hasAdd = false;
                for (HostInfo hostInfo : this.mtHostList) {
                    if (!hostInfo.equals(readyToAddHost)) continue;
                    hasAdd = true;
                    hostInfo.setRetryTimes(server.getRetryTimes());
                    hostInfo.setRetryInterval(server.getRetryInterval());
                    break;
                }
                if (hasAdd) continue;
                for (HostInfo hostInfo : this.failureMtHostList) {
                    if (!hostInfo.equals(readyToAddHost)) continue;
                    hasAdd = true;
                    hostInfo.setRetryTimes(server.getRetryTimes());
                    hostInfo.setRetryInterval(server.getRetryInterval());
                    break;
                }
                if (hasAdd) continue;
                this.mtHostList.add(readyToAddHost);
            }
            for (HostInfo host : this.mtHostList) {
                if (tempMtHostList.contains(host)) continue;
                this.mtHostList.remove(host);
            }
            for (HostInfo host : this.failureMtHostList) {
                if (tempMtHostList.contains(host)) continue;
                this.failureMtHostList.remove(host);
            }
            int size = this.mtHostList.size();
            if (this.markMtHostPosition >= size) {
                this.markMtHostPosition = size - 1;
            }
        }
        finally {
            this.mtHostLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configMoServer(MoServerConfig config) {
        List<MoServer> servers;
        if (config == null) {
            return;
        }
        MoServerAttributes attributes = config.getAttributes();
        if (attributes != null && attributes.getTrySwitchTimes() >= 0) {
            this.moTrySwitchTimes = attributes.getTrySwitchTimes();
        }
        if ((servers = config.getMoServers()) == null) {
            return;
        }
        ArrayList<HostInfo> tempMoHostList = new ArrayList<HostInfo>();
        this.moHostLock.lock();
        try {
            for (MoServer server : servers) {
                String ip = server.getIp();
                int port = server.getPort();
                if (StringUtils.isBlank(ip) || port < 0 || port > 65535) continue;
                HostInfo readyToAddHost = new HostInfo(ip, port);
                readyToAddHost.setRetryTimes(server.getRetryTimes());
                readyToAddHost.setRetryInterval(server.getRetryInterval());
                tempMoHostList.add(readyToAddHost);
                boolean hasAdd = false;
                for (HostInfo hostInfo : this.moHostList) {
                    if (!hostInfo.equals(readyToAddHost)) continue;
                    hasAdd = true;
                    hostInfo.setRetryTimes(server.getRetryTimes());
                    hostInfo.setRetryInterval(server.getRetryInterval());
                    break;
                }
                if (hasAdd) continue;
                for (HostInfo hostInfo : this.failureMoHostList) {
                    if (!hostInfo.equals(readyToAddHost)) continue;
                    hasAdd = true;
                    hostInfo.setRetryTimes(server.getRetryTimes());
                    hostInfo.setRetryInterval(server.getRetryInterval());
                    break;
                }
                if (hasAdd) continue;
                this.moHostList.add(readyToAddHost);
            }
            for (HostInfo host : this.moHostList) {
                if (tempMoHostList.contains(host)) continue;
                this.moHostList.remove(host);
            }
            for (HostInfo host : this.failureMoHostList) {
                if (tempMoHostList.contains(host)) continue;
                this.failureMoHostList.remove(host);
            }
            int size = this.moHostList.size();
            if (this.markMoHostPosition >= size) {
                this.markMoHostPosition = size - 1;
            }
        }
        finally {
            this.moHostLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkMtAndMoServer() {
        for (HostInfo server : this.failureMtHostList) {
            if (!this.isValidService(server.getIp(), server.getPort())) continue;
            this.mtHostLock.lock();
            try {
                this.mtHostList.add(server);
                this.failureMtHostList.remove(server);
            }
            finally {
                this.mtHostLock.unlock();
            }
        }
        for (HostInfo server : this.failureMoHostList) {
            if (!this.isValidService(server.getIp(), server.getPort())) continue;
            this.moHostLock.lock();
            try {
                this.moHostList.add(server);
                this.failureMoHostList.remove(server);
            }
            finally {
                this.moHostLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidService(String ip, int port) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setSoTimeout(5000);
            socket.connect(new InetSocketAddress(ip, port));
            boolean bl = socket.isConnected();
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public HostInfo takeOneMtServer() {
        if (this.mtHostList == null || this.mtHostList.size() == 0) {
            return null;
        }
        this.mtHostLock.lock();
        try {
            ++this.markMtHostPosition;
            if (this.markMtHostPosition >= this.mtHostList.size() || this.markMtHostPosition < 0) {
                this.markMtHostPosition = 0;
            }
            HostInfo hostInfo = this.mtHostList.get(this.markMtHostPosition);
            return hostInfo;
        }
        finally {
            this.mtHostLock.unlock();
        }
    }

    public HostInfo takeOneMoServer() {
        if (this.moHostList == null || this.moHostList.size() == 0) {
            return null;
        }
        this.moHostLock.lock();
        try {
            ++this.markMoHostPosition;
            if (this.markMoHostPosition >= this.moHostList.size() || this.markMoHostPosition < 0) {
                this.markMoHostPosition = 0;
            }
            HostInfo hostInfo = this.moHostList.get(this.markMoHostPosition);
            return hostInfo;
        }
        finally {
            this.moHostLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCrashMtServer(HostInfo crashServer) {
        this.mtHostLock.lock();
        try {
            if (this.failureMtHostList.contains(crashServer)) {
                return;
            }
            for (int i = 0; i < this.mtHostList.size(); ++i) {
                HostInfo server = this.mtHostList.get(i);
                if (!server.equals(crashServer)) continue;
                this.mtHostList.remove(i);
                if (this.markMtHostPosition < i) break;
                --this.markMtHostPosition;
                break;
            }
            this.failureMtHostList.add(crashServer);
        }
        finally {
            this.mtHostLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCrashMoServer(HostInfo crashServer) {
        this.moHostLock.lock();
        try {
            if (this.failureMoHostList.contains(crashServer)) {
                return;
            }
            for (int i = 0; i < this.moHostList.size(); ++i) {
                HostInfo server = this.moHostList.get(i);
                if (!server.equals(crashServer)) continue;
                this.moHostList.remove(i);
                if (this.markMoHostPosition < i) break;
                --this.markMoHostPosition;
                break;
            }
            this.failureMoHostList.add(crashServer);
        }
        finally {
            this.moHostLock.unlock();
        }
    }

    public void setInitMtServer(HostInfo initMtServer) {
        this.initMtServer = initMtServer;
    }

    public void setInitMoServer(HostInfo initMoServer) {
        this.initMoServer = initMoServer;
    }

    public int getMtTrySwitchTimes() {
        return this.mtTrySwitchTimes;
    }

    public int getMoTrySwitchTimes() {
        return this.moTrySwitchTimes;
    }

    private static class HAMonitorHolder {
        private static final HAMonitor INSTANCE = new HAMonitor();

        private HAMonitorHolder() {
        }
    }
}

