/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.ha;

import com.xuanwu.mos.HostInfo;
import com.xuanwu.mos.common.log.PostMsgLogger;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MoInvokeAdaptor<T> {
    public abstract T invoke() throws Exception;

    public T invokeWithInternalRetry(HostInfo hostInfo, String method) throws Exception {
        int retryTimes = hostInfo.getRetryTimes();
        int retryInterval = hostInfo.getRetryInterval();
        if (retryTimes < 1 || retryInterval < 1) {
            return this.invoke();
        }
        try {
            return this.invoke();
        }
        catch (Exception e) {
            for (int i = 0; i < retryTimes; ++i) {
                PostMsgLogger.logCommWarn(method, "Sent error(" + hostInfo + "), sleep for a while and retry, caused by: " + e.getMessage());
                TimeUnit.MILLISECONDS.sleep(retryInterval);
                try {
                    return this.invoke();
                }
                catch (Exception e1) {
                    if (i < retryTimes - 1) continue;
                    throw e1;
                }
            }
            throw e;
        }
    }
}

