/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.ha;

import com.xuanwu.mos.HostInfo;
import com.xuanwu.mos.common.entity.GsmsResponse;
import com.xuanwu.mos.common.log.PostMsgLogger;
import java.io.EOFException;
import java.util.concurrent.TimeUnit;

public abstract class MtInvokeAdaptor {
    public static volatile boolean retryWhenEOFException = true;

    public abstract GsmsResponse invoke() throws Exception;

    private GsmsResponse invoke0(String method) throws Exception {
        if (retryWhenEOFException) {
            try {
                return this.invoke();
            }
            catch (EOFException eof) {
                PostMsgLogger.logWarn(method, "Invalid connection, retry with a new connection");
                return this.invoke();
            }
        }
        return this.invoke();
    }

    public GsmsResponse invokeWithInternalRetry(HostInfo hostInfo, String method) throws Exception {
        int tryCount;
        int retryTimes = hostInfo.getRetryTimes();
        int retryInterval = hostInfo.getRetryInterval();
        if (retryTimes < 1 || retryInterval < 1) {
            return this.invoke0(method);
        }
        try {
            GsmsResponse resp = this.invoke0(method);
            if (this.isServerBusy(resp)) {
                for (tryCount = 0; tryCount < retryTimes; ++tryCount) {
                    PostMsgLogger.logWarn(method, "The server is busy(" + hostInfo + "), sleep for a while and retry");
                    TimeUnit.MILLISECONDS.sleep(retryInterval);
                    resp = this.invoke0(method);
                    if (this.isServerBusy(resp)) continue;
                    return resp;
                }
            }
            return resp;
        }
        catch (Exception e) {
            while (tryCount < retryTimes) {
                PostMsgLogger.logCommWarn(method, "Sent error(" + hostInfo + "), sleep for a while and retry, caused by: " + e.getMessage());
                TimeUnit.MILLISECONDS.sleep(retryInterval);
                try {
                    return this.invoke0(method);
                }
                catch (Exception e1) {
                    if (tryCount >= retryTimes - 1) {
                        throw e1;
                    }
                    ++tryCount;
                }
            }
            throw e;
        }
    }

    private boolean isServerBusy(GsmsResponse resp) {
        int result = resp.getResult();
        return result == -1011 || result == -1012;
    }
}

