/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.profiles;

import com.xuanwu.mos.common.log.PostMsgLogger;
import com.xuanwu.mos.common.util.StringUtils;
import com.xuanwu.mos.common.util.http.HttpResponse;
import com.xuanwu.mos.common.util.http.WebUtils;
import com.xuanwu.mos.common.util.xml.XStreamUtil;
import com.xuanwu.mos.config.ConfigControlCenter;
import com.xuanwu.mos.config.PostMsgConfig;
import com.xuanwu.mos.profiles.UserProfiles;
import com.xuanwu.mos.profiles.UserProfilesListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class UserProfilesService {
    private List<UserProfilesListener> listeners = new ArrayList<UserProfilesListener>(5);
    private final Object listenersLock = new Object();
    private Thread fetchThread;
    private volatile boolean stopFetch = true;
    private UserProfiles userProfiles;
    private String globalProfilesAccount;

    public static UserProfilesService getInstance() {
        return UserProfilesServiceHolder.INSTANCE;
    }

    private UserProfilesService() {
        XStreamUtil.alias("userProfiles", UserProfiles.class);
    }

    public void setGlobalProfilesAccount(String accountName) {
        this.globalProfilesAccount = accountName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUserProfilesListener(UserProfilesListener listener) {
        if (listener == null) {
            return;
        }
        UserProfilesService inst = UserProfilesService.getInstance();
        Object object = inst.listenersLock;
        synchronized (object) {
            if (!inst.listeners.contains(listener)) {
                inst.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUserProfilesListener(UserProfilesListener listener) {
        if (listener == null) {
            return;
        }
        UserProfilesService inst = UserProfilesService.getInstance();
        Object object = inst.listenersLock;
        synchronized (object) {
            inst.listeners.remove(listener);
        }
    }

    public synchronized void startFetchThread() {
        if (!this.stopFetch) {
            return;
        }
        PostMsgLogger.logInfo("Starting user profiles update thread ...");
        this.fetchThread = new Thread(){

            public void run() {
                while (!UserProfilesService.this.stopFetch) {
                    try {
                        int fetchIntervalSeconds = PostMsgConfig.getUserProfilesFetchIntervalSeconds();
                        if (fetchIntervalSeconds < 1) {
                            fetchIntervalSeconds = 30;
                        }
                        TimeUnit.SECONDS.sleep(fetchIntervalSeconds);
                        String accountName = null;
                        accountName = UserProfilesService.this.globalProfilesAccount != null ? UserProfilesService.this.globalProfilesAccount : ConfigControlCenter.accountName;
                        if (accountName == null) continue;
                        UserProfilesService.this.fetchUserProfiles(PostMsgConfig.getUserProfilesServerUrl(), accountName);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (Exception e) {
                        PostMsgLogger.logError("Fetch user profiles error: " + e.getMessage());
                    }
                }
            }
        };
        this.stopFetch = false;
        this.fetchThread.setName("Fetch user-profiles thread");
        this.fetchThread.setDaemon(true);
        this.fetchThread.start();
        PostMsgLogger.logInfo("User profiles update thread started");
    }

    public synchronized void stopFetchThread() {
        if (this.stopFetch) {
            return;
        }
        try {
            if (this.fetchThread != null) {
                this.fetchThread.interrupt();
                PostMsgLogger.logInfo("User profiles update thread stoped");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stopFetch = true;
    }

    public UserProfiles fetchUserProfiles(String serverUrl, String accountName) throws Exception {
        if (StringUtils.isBlank(serverUrl)) {
            throw new IllegalArgumentException("serverUrl is blank");
        }
        PostMsgLogger.logInfo("Starting fetch user profiles ...");
        String reqUrl = serverUrl + "?account=" + accountName;
        HttpResponse response = WebUtils.doGet(reqUrl, null, 3000, 5000);
        if (response.getStatusCode() != 200) {
            throw new RuntimeException("Fetch user profiles http code: " + response.getStatusCode() + ", content: " + response.getContent());
        }
        String conetnt = response.getContent();
        if (StringUtils.isBlank(conetnt)) {
            throw new RuntimeException("Fetch user profiles return empty content");
        }
        this.userProfiles = (UserProfiles)XStreamUtil.fromXML(conetnt);
        for (UserProfilesListener listener : this.listeners) {
            try {
                listener.notifyWhenRefresh();
            }
            catch (Exception exception) {}
        }
        return this.userProfiles;
    }

    public static UserProfiles getUserProfiles() {
        return UserProfilesService.getInstance().userProfiles;
    }

    public boolean isStopFetch() {
        return this.stopFetch;
    }

    private static class UserProfilesServiceHolder {
        private static final UserProfilesService INSTANCE = new UserProfilesService();

        private UserProfilesServiceHolder() {
        }
    }
}

