/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.thirdparty.com.thoughtworks.xstream;

import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.MarshallingStrategy;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.XStreamException;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.Converter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.ConverterLookup;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.ConverterRegistry;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.DataHolder;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.SingleValueConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.SingleValueConverterWrapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.BigDecimalConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.BigIntegerConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.CharConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.DateConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.DoubleConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.FloatConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.IntConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.LongConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.NullConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.ShortConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.StringBufferConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.StringConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.URLConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.collections.ArrayConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.collections.BitSetConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.collections.CharArrayConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.collections.MapConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.collections.PropertiesConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.collections.TreeMapConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.collections.TreeSetConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.reflection.ExternalizableConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.reflection.SelfStreamingInstanceChecker;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.core.DefaultConverterLookup;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.core.JVM;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.core.ReferenceByIdMarshallingStrategy;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.core.ReferenceByXPathMarshallingStrategy;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.core.TreeMarshallingStrategy;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.core.util.ClassLoaderReference;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.core.util.CompositeClassLoader;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.core.util.CustomObjectInputStream;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.io.StatefulWriter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.io.xml.XppDriver;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.AnnotationConfiguration;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.ArrayMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.AttributeAliasingMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.AttributeMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.CachingMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.ClassAliasingMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.DefaultImplementationsMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.DefaultMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.DynamicProxyMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.FieldAliasingMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.ImmutableTypesMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.ImplicitCollectionMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.LocalConversionMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.Mapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.MapperWrapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.OuterClassMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.PackageAliasingMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.SystemAttributeAliasingMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.XStream11XmlFriendlyMapper;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class XStream {
    private ReflectionProvider reflectionProvider;
    private HierarchicalStreamDriver hierarchicalStreamDriver;
    private ClassLoaderReference classLoaderReference;
    private MarshallingStrategy marshallingStrategy;
    private ConverterLookup converterLookup;
    private ConverterRegistry converterRegistry;
    private Mapper mapper;
    private PackageAliasingMapper packageAliasingMapper;
    private ClassAliasingMapper classAliasingMapper;
    private FieldAliasingMapper fieldAliasingMapper;
    private AttributeAliasingMapper attributeAliasingMapper;
    private SystemAttributeAliasingMapper systemAttributeAliasingMapper;
    private AttributeMapper attributeMapper;
    private DefaultImplementationsMapper defaultImplementationsMapper;
    private ImmutableTypesMapper immutableTypesMapper;
    private ImplicitCollectionMapper implicitCollectionMapper;
    private LocalConversionMapper localConversionMapper;
    private AnnotationConfiguration annotationConfiguration;
    private transient JVM jvm = new JVM();
    public static final int NO_REFERENCES = 1001;
    public static final int ID_REFERENCES = 1002;
    public static final int XPATH_RELATIVE_REFERENCES = 1003;
    public static final int XPATH_ABSOLUTE_REFERENCES = 1004;
    public static final int XPATH_REFERENCES = 1003;
    public static final int PRIORITY_VERY_HIGH = 10000;
    public static final int PRIORITY_NORMAL = 0;
    public static final int PRIORITY_LOW = -10;
    public static final int PRIORITY_VERY_LOW = -20;
    private static final String ANNOTATION_MAPPER_TYPE = "com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.AnnotationMapper";

    public XStream() {
        this(null, (Mapper)null, new XppDriver());
    }

    public XStream(ReflectionProvider reflectionProvider) {
        this(reflectionProvider, (Mapper)null, new XppDriver());
    }

    public XStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
        this(null, (Mapper)null, hierarchicalStreamDriver);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver) {
        this(reflectionProvider, (Mapper)null, hierarchicalStreamDriver);
    }

    public XStream(ReflectionProvider reflectionProvider, Mapper mapper, HierarchicalStreamDriver driver) {
        this(reflectionProvider, driver, new ClassLoaderReference(new CompositeClassLoader()), mapper, new DefaultConverterLookup(), null);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader) {
        this(reflectionProvider, driver, classLoader, null);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader, Mapper mapper) {
        this(reflectionProvider, driver, classLoader, mapper, new DefaultConverterLookup(), null);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader, Mapper mapper, ConverterLookup converterLookup, ConverterRegistry converterRegistry) {
        if (reflectionProvider == null) {
            reflectionProvider = this.jvm.bestReflectionProvider();
        }
        this.reflectionProvider = reflectionProvider;
        this.hierarchicalStreamDriver = driver;
        this.classLoaderReference = classLoader instanceof ClassLoaderReference ? (ClassLoaderReference)classLoader : new ClassLoaderReference(classLoader);
        this.converterLookup = converterLookup;
        this.converterRegistry = converterRegistry != null ? converterRegistry : (converterLookup instanceof ConverterRegistry ? (ConverterRegistry)((Object)converterLookup) : null);
        this.mapper = mapper == null ? this.buildMapper() : mapper;
        this.setupMappers();
        this.setupAliases();
        this.setupDefaultImplementations();
        this.setupConverters();
        this.setupImmutableTypes();
        this.setMode(1003);
    }

    private Mapper buildMapper() {
        Mapper mapper = new DefaultMapper(this.classLoaderReference);
        if (this.useXStream11XmlFriendlyMapper()) {
            mapper = new XStream11XmlFriendlyMapper(mapper);
        }
        mapper = new DynamicProxyMapper(mapper);
        mapper = new PackageAliasingMapper(mapper);
        mapper = new ClassAliasingMapper(mapper);
        mapper = new FieldAliasingMapper(mapper);
        mapper = new AttributeAliasingMapper(mapper);
        mapper = new SystemAttributeAliasingMapper(mapper);
        mapper = new ImplicitCollectionMapper(mapper);
        mapper = new OuterClassMapper(mapper);
        mapper = new ArrayMapper(mapper);
        mapper = new DefaultImplementationsMapper(mapper);
        mapper = new AttributeMapper(mapper, this.converterLookup);
        if (JVM.is15()) {
            mapper = this.buildMapperDynamically("com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.EnumMapper", new Class[]{Mapper.class}, new Object[]{mapper});
        }
        mapper = new LocalConversionMapper(mapper);
        mapper = new ImmutableTypesMapper(mapper);
        if (JVM.is15()) {
            mapper = this.buildMapperDynamically(ANNOTATION_MAPPER_TYPE, new Class[]{Mapper.class, ConverterRegistry.class, ClassLoader.class, ReflectionProvider.class, JVM.class}, new Object[]{mapper, this.converterLookup, this.classLoaderReference, this.reflectionProvider, this.jvm});
        }
        mapper = this.wrapMapper((MapperWrapper)mapper);
        mapper = new CachingMapper(mapper);
        return mapper;
    }

    private Mapper buildMapperDynamically(String className, Class[] constructorParamTypes, Object[] constructorParamValues) {
        try {
            Class<?> type = Class.forName(className, false, this.classLoaderReference.getReference());
            Constructor<?> constructor = type.getConstructor(constructorParamTypes);
            return (Mapper)constructor.newInstance(constructorParamValues);
        }
        catch (Exception e) {
            throw new InitializationException("Could not instantiate mapper : " + className, e);
        }
    }

    protected MapperWrapper wrapMapper(MapperWrapper next) {
        return next;
    }

    protected boolean useXStream11XmlFriendlyMapper() {
        return false;
    }

    private void setupMappers() {
        this.packageAliasingMapper = (PackageAliasingMapper)this.mapper.lookupMapperOfType(PackageAliasingMapper.class);
        this.classAliasingMapper = (ClassAliasingMapper)this.mapper.lookupMapperOfType(ClassAliasingMapper.class);
        this.fieldAliasingMapper = (FieldAliasingMapper)this.mapper.lookupMapperOfType(FieldAliasingMapper.class);
        this.attributeMapper = (AttributeMapper)this.mapper.lookupMapperOfType(AttributeMapper.class);
        this.attributeAliasingMapper = (AttributeAliasingMapper)this.mapper.lookupMapperOfType(AttributeAliasingMapper.class);
        this.systemAttributeAliasingMapper = (SystemAttributeAliasingMapper)this.mapper.lookupMapperOfType(SystemAttributeAliasingMapper.class);
        this.implicitCollectionMapper = (ImplicitCollectionMapper)this.mapper.lookupMapperOfType(ImplicitCollectionMapper.class);
        this.defaultImplementationsMapper = (DefaultImplementationsMapper)this.mapper.lookupMapperOfType(DefaultImplementationsMapper.class);
        this.immutableTypesMapper = (ImmutableTypesMapper)this.mapper.lookupMapperOfType(ImmutableTypesMapper.class);
        this.localConversionMapper = (LocalConversionMapper)this.mapper.lookupMapperOfType(LocalConversionMapper.class);
        this.annotationConfiguration = (AnnotationConfiguration)((Object)this.mapper.lookupMapperOfType(AnnotationConfiguration.class));
    }

    protected void setupAliases() {
        if (this.classAliasingMapper == null) {
            return;
        }
        this.alias("null", Mapper.Null.class);
        this.alias("int", Integer.class);
        this.alias("float", Float.class);
        this.alias("double", Double.class);
        this.alias("long", Long.class);
        this.alias("short", Short.class);
        this.alias("char", Character.class);
        this.alias("byte", Byte.class);
        this.alias("boolean", Boolean.class);
        this.alias("number", Number.class);
        this.alias("object", Object.class);
        this.alias("big-int", BigInteger.class);
        this.alias("big-decimal", BigDecimal.class);
        this.alias("string-buffer", StringBuffer.class);
        this.alias("string", String.class);
        this.alias("java-class", Class.class);
        this.alias("method", Method.class);
        this.alias("constructor", Constructor.class);
        this.alias("date", Date.class);
        this.alias("url", URL.class);
        this.alias("bit-set", BitSet.class);
        this.alias("map", Map.class);
        this.alias("entry", Map.Entry.class);
        this.alias("properties", Properties.class);
        this.alias("list", List.class);
        this.alias("set", Set.class);
        this.alias("linked-list", LinkedList.class);
        this.alias("vector", Vector.class);
        this.alias("tree-map", TreeMap.class);
        this.alias("tree-set", TreeSet.class);
        this.alias("hashtable", Hashtable.class);
        if (this.jvm.supportsAWT()) {
            this.alias("awt-color", this.jvm.loadClass("java.awt.Color"));
            this.alias("awt-font", this.jvm.loadClass("java.awt.Font"));
            this.alias("awt-text-attribute", this.jvm.loadClass("java.awt.font.TextAttribute"));
        }
        if (this.jvm.supportsSQL()) {
            this.alias("sql-timestamp", this.jvm.loadClass("java.sql.Timestamp"));
            this.alias("sql-time", this.jvm.loadClass("java.sql.Time"));
            this.alias("sql-date", this.jvm.loadClass("java.sql.Date"));
        }
        this.alias("file", File.class);
        this.alias("locale", Locale.class);
        this.alias("gregorian-calendar", Calendar.class);
        if (JVM.is14()) {
            this.alias("auth-subject", this.jvm.loadClass("javax.security.auth.Subject"));
            this.alias("linked-hash-map", this.jvm.loadClass("java.util.LinkedHashMap"));
            this.alias("linked-hash-set", this.jvm.loadClass("java.util.LinkedHashSet"));
            this.alias("trace", this.jvm.loadClass("java.lang.StackTraceElement"));
            this.alias("currency", this.jvm.loadClass("java.util.Currency"));
            this.aliasType("charset", this.jvm.loadClass("java.nio.charset.Charset"));
        }
        if (JVM.is15()) {
            this.alias("duration", this.jvm.loadClass("javax.xml.datatype.Duration"));
            this.alias("enum-set", this.jvm.loadClass("java.util.EnumSet"));
            this.alias("enum-map", this.jvm.loadClass("java.util.EnumMap"));
            this.alias("string-builder", this.jvm.loadClass("java.lang.StringBuilder"));
            this.alias("uuid", this.jvm.loadClass("java.util.UUID"));
        }
    }

    protected void setupDefaultImplementations() {
        if (this.defaultImplementationsMapper == null) {
            return;
        }
        this.addDefaultImplementation(HashMap.class, Map.class);
        this.addDefaultImplementation(ArrayList.class, List.class);
        this.addDefaultImplementation(HashSet.class, Set.class);
        this.addDefaultImplementation(GregorianCalendar.class, Calendar.class);
    }

    protected void setupConverters() {
        ReflectionConverter reflectionConverter = new ReflectionConverter(this.mapper, this.reflectionProvider);
        this.registerConverter(reflectionConverter, -20);
        this.registerConverter(new SerializableConverter(this.mapper, this.reflectionProvider), -10);
        this.registerConverter(new ExternalizableConverter(this.mapper), -10);
        this.registerConverter(new NullConverter(), 10000);
        this.registerConverter(new IntConverter(), 0);
        this.registerConverter(new FloatConverter(), 0);
        this.registerConverter(new DoubleConverter(), 0);
        this.registerConverter(new LongConverter(), 0);
        this.registerConverter(new ShortConverter(), 0);
        this.registerConverter(new CharConverter(), 0);
        this.registerConverter(new BooleanConverter(), 0);
        this.registerConverter(new ByteConverter(), 0);
        this.registerConverter(new StringConverter(), 0);
        this.registerConverter(new StringBufferConverter(), 0);
        this.registerConverter(new DateConverter(), 0);
        this.registerConverter(new BitSetConverter(), 0);
        this.registerConverter(new URLConverter(), 0);
        this.registerConverter(new BigIntegerConverter(), 0);
        this.registerConverter(new BigDecimalConverter(), 0);
        this.registerConverter(new ArrayConverter(this.mapper), 0);
        this.registerConverter(new CharArrayConverter(), 0);
        this.registerConverter(new CollectionConverter(this.mapper), 0);
        this.registerConverter(new MapConverter(this.mapper), 0);
        this.registerConverter(new TreeMapConverter(this.mapper), 0);
        this.registerConverter(new TreeSetConverter(this.mapper), 0);
        this.registerConverter(new PropertiesConverter(), 0);
        if (JVM.is14()) {
            this.dynamicallyRegisterConverter("com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.extended.SubjectConverter", 0, new Class[]{Mapper.class}, new Object[]{this.mapper});
            this.dynamicallyRegisterConverter("com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.extended.ThrowableConverter", 0, new Class[]{Converter.class}, new Object[]{reflectionConverter});
            this.dynamicallyRegisterConverter("com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.extended.StackTraceElementConverter", 0, null, null);
            this.dynamicallyRegisterConverter("com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.extended.CurrencyConverter", 0, null, null);
            this.dynamicallyRegisterConverter("com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.extended.RegexPatternConverter", 0, new Class[]{Converter.class}, new Object[]{reflectionConverter});
            this.dynamicallyRegisterConverter("com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.extended.CharsetConverter", 0, null, null);
        }
        if (JVM.is15()) {
            this.dynamicallyRegisterConverter("com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.extended.DurationConverter", 0, null, null);
            this.dynamicallyRegisterConverter("com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.enums.EnumConverter", 0, null, null);
            this.dynamicallyRegisterConverter("com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.enums.EnumSetConverter", 0, new Class[]{Mapper.class}, new Object[]{this.mapper});
            this.dynamicallyRegisterConverter("com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.enums.EnumMapConverter", 0, new Class[]{Mapper.class}, new Object[]{this.mapper});
            this.dynamicallyRegisterConverter("com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.StringBuilderConverter", 0, null, null);
            this.dynamicallyRegisterConverter("com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.UUIDConverter", 0, null, null);
        }
        this.registerConverter(new SelfStreamingInstanceChecker(reflectionConverter, this), 0);
    }

    private void dynamicallyRegisterConverter(String className, int priority, Class[] constructorParamTypes, Object[] constructorParamValues) {
        try {
            Class<?> type = Class.forName(className, false, this.classLoaderReference.getReference());
            Constructor<?> constructor = type.getConstructor(constructorParamTypes);
            Object instance = constructor.newInstance(constructorParamValues);
            if (instance instanceof Converter) {
                this.registerConverter((Converter)instance, priority);
            } else if (instance instanceof SingleValueConverter) {
                this.registerConverter((SingleValueConverter)instance, priority);
            }
        }
        catch (Exception e) {
            throw new InitializationException("Could not instantiate converter : " + className, e);
        }
    }

    protected void setupImmutableTypes() {
        if (this.immutableTypesMapper == null) {
            return;
        }
        this.addImmutableType(Boolean.TYPE);
        this.addImmutableType(Boolean.class);
        this.addImmutableType(Byte.TYPE);
        this.addImmutableType(Byte.class);
        this.addImmutableType(Character.TYPE);
        this.addImmutableType(Character.class);
        this.addImmutableType(Double.TYPE);
        this.addImmutableType(Double.class);
        this.addImmutableType(Float.TYPE);
        this.addImmutableType(Float.class);
        this.addImmutableType(Integer.TYPE);
        this.addImmutableType(Integer.class);
        this.addImmutableType(Long.TYPE);
        this.addImmutableType(Long.class);
        this.addImmutableType(Short.TYPE);
        this.addImmutableType(Short.class);
        this.addImmutableType(Mapper.Null.class);
        this.addImmutableType(BigDecimal.class);
        this.addImmutableType(BigInteger.class);
        this.addImmutableType(String.class);
        this.addImmutableType(URL.class);
        this.addImmutableType(File.class);
        this.addImmutableType(Class.class);
        if (this.jvm.supportsAWT()) {
            this.addImmutableType(this.jvm.loadClass("java.awt.font.TextAttribute"));
        }
        if (JVM.is14()) {
            Class type = this.jvm.loadClass("com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.extended.CharsetConverter");
            this.addImmutableType(type);
        }
    }

    public void setMarshallingStrategy(MarshallingStrategy marshallingStrategy) {
        this.marshallingStrategy = marshallingStrategy;
    }

    public String toXML(Object obj) {
        StringWriter writer = new StringWriter();
        this.toXML(obj, writer);
        return ((Object)writer).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXML(Object obj, Writer out) {
        HierarchicalStreamWriter writer = this.hierarchicalStreamDriver.createWriter(out);
        try {
            this.marshal(obj, writer);
            Object var5_4 = null;
            writer.flush();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            writer.flush();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXML(Object obj, OutputStream out) {
        HierarchicalStreamWriter writer = this.hierarchicalStreamDriver.createWriter(out);
        try {
            this.marshal(obj, writer);
            Object var5_4 = null;
            writer.flush();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            writer.flush();
            throw throwable;
        }
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer) {
        this.marshal(obj, writer, null);
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer, DataHolder dataHolder) {
        this.marshallingStrategy.marshal(writer, obj, this.converterLookup, this.mapper, dataHolder);
    }

    public Object fromXML(String xml) {
        return this.fromXML(new StringReader(xml));
    }

    public Object fromXML(Reader xml) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(xml), null);
    }

    public Object fromXML(InputStream input) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(input), null);
    }

    public Object fromXML(String xml, Object root) {
        return this.fromXML(new StringReader(xml), root);
    }

    public Object fromXML(Reader xml, Object root) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(xml), root);
    }

    public Object fromXML(InputStream xml, Object root) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(xml), root);
    }

    public Object unmarshal(HierarchicalStreamReader reader) {
        return this.unmarshal(reader, null, null);
    }

    public Object unmarshal(HierarchicalStreamReader reader, Object root) {
        return this.unmarshal(reader, root, null);
    }

    public Object unmarshal(HierarchicalStreamReader reader, Object root, DataHolder dataHolder) {
        return this.marshallingStrategy.unmarshal(root, reader, dataHolder, this.converterLookup, this.mapper);
    }

    public void alias(String name, Class type) {
        if (this.classAliasingMapper == null) {
            throw new InitializationException("No " + ClassAliasingMapper.class.getName() + " available");
        }
        this.classAliasingMapper.addClassAlias(name, type);
    }

    public void aliasType(String name, Class type) {
        if (this.classAliasingMapper == null) {
            throw new InitializationException("No " + ClassAliasingMapper.class.getName() + " available");
        }
        this.classAliasingMapper.addTypeAlias(name, type);
    }

    public void alias(String name, Class type, Class defaultImplementation) {
        this.alias(name, type);
        this.addDefaultImplementation(defaultImplementation, type);
    }

    public void aliasPackage(String name, String pkgName) {
        if (this.packageAliasingMapper == null) {
            throw new InitializationException("No " + PackageAliasingMapper.class.getName() + " available");
        }
        this.packageAliasingMapper.addPackageAlias(name, pkgName);
    }

    public void aliasField(String alias, Class definedIn, String fieldName) {
        if (this.fieldAliasingMapper == null) {
            throw new InitializationException("No " + FieldAliasingMapper.class.getName() + " available");
        }
        this.fieldAliasingMapper.addFieldAlias(alias, definedIn, fieldName);
    }

    public void aliasAttribute(String alias, String attributeName) {
        if (this.attributeAliasingMapper == null) {
            throw new InitializationException("No " + AttributeAliasingMapper.class.getName() + " available");
        }
        this.attributeAliasingMapper.addAliasFor(attributeName, alias);
    }

    public void aliasSystemAttribute(String alias, String systemAttributeName) {
        if (this.systemAttributeAliasingMapper == null) {
            throw new InitializationException("No " + SystemAttributeAliasingMapper.class.getName() + " available");
        }
        this.systemAttributeAliasingMapper.addAliasFor(systemAttributeName, alias);
    }

    public void aliasAttribute(Class definedIn, String attributeName, String alias) {
        this.aliasField(alias, definedIn, attributeName);
        this.useAttributeFor(definedIn, attributeName);
    }

    public void useAttributeFor(String fieldName, Class type) {
        if (this.attributeMapper == null) {
            throw new InitializationException("No " + AttributeMapper.class.getName() + " available");
        }
        this.attributeMapper.addAttributeFor(fieldName, type);
    }

    public void useAttributeFor(Class definedIn, String fieldName) {
        if (this.attributeMapper == null) {
            throw new InitializationException("No " + AttributeMapper.class.getName() + " available");
        }
        this.attributeMapper.addAttributeFor(definedIn, fieldName);
    }

    public void useAttributeFor(Class type) {
        if (this.attributeMapper == null) {
            throw new InitializationException("No " + AttributeMapper.class.getName() + " available");
        }
        this.attributeMapper.addAttributeFor(type);
    }

    public void addDefaultImplementation(Class defaultImplementation, Class ofType) {
        if (this.defaultImplementationsMapper == null) {
            throw new InitializationException("No " + DefaultImplementationsMapper.class.getName() + " available");
        }
        this.defaultImplementationsMapper.addDefaultImplementation(defaultImplementation, ofType);
    }

    public void addImmutableType(Class type) {
        if (this.immutableTypesMapper == null) {
            throw new InitializationException("No " + ImmutableTypesMapper.class.getName() + " available");
        }
        this.immutableTypesMapper.addImmutableType(type);
    }

    public void registerConverter(Converter converter) {
        this.registerConverter(converter, 0);
    }

    public void registerConverter(Converter converter, int priority) {
        if (this.converterRegistry != null) {
            this.converterRegistry.registerConverter(converter, priority);
        }
    }

    public void registerConverter(SingleValueConverter converter) {
        this.registerConverter(converter, 0);
    }

    public void registerConverter(SingleValueConverter converter, int priority) {
        if (this.converterRegistry != null) {
            this.converterRegistry.registerConverter(new SingleValueConverterWrapper(converter), priority);
        }
    }

    public void registerLocalConverter(Class definedIn, String fieldName, Converter converter) {
        if (this.localConversionMapper == null) {
            throw new InitializationException("No " + LocalConversionMapper.class.getName() + " available");
        }
        this.localConversionMapper.registerLocalConverter(definedIn, fieldName, converter);
    }

    public void registerLocalConverter(Class definedIn, String fieldName, SingleValueConverter converter) {
        this.registerLocalConverter(definedIn, fieldName, new SingleValueConverterWrapper(converter));
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public ReflectionProvider getReflectionProvider() {
        return this.reflectionProvider;
    }

    public ConverterLookup getConverterLookup() {
        return this.converterLookup;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 1001: {
                this.setMarshallingStrategy(new TreeMarshallingStrategy());
                break;
            }
            case 1002: {
                this.setMarshallingStrategy(new ReferenceByIdMarshallingStrategy());
                break;
            }
            case 1003: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy(ReferenceByXPathMarshallingStrategy.RELATIVE));
                break;
            }
            case 1004: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy(ReferenceByXPathMarshallingStrategy.ABSOLUTE));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode : " + mode);
            }
        }
    }

    public void addImplicitCollection(Class ownerType, String fieldName) {
        if (this.implicitCollectionMapper == null) {
            throw new InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
        }
        this.implicitCollectionMapper.add(ownerType, fieldName, null, null);
    }

    public void addImplicitCollection(Class ownerType, String fieldName, Class itemType) {
        if (this.implicitCollectionMapper == null) {
            throw new InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
        }
        this.implicitCollectionMapper.add(ownerType, fieldName, null, itemType);
    }

    public void addImplicitCollection(Class ownerType, String fieldName, String itemFieldName, Class itemType) {
        if (this.implicitCollectionMapper == null) {
            throw new InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
        }
        this.implicitCollectionMapper.add(ownerType, fieldName, itemFieldName, itemType);
    }

    public DataHolder newDataHolder() {
        return new MapBackedDataHolder();
    }

    public ObjectOutputStream createObjectOutputStream(Writer writer) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(writer), "object-stream");
    }

    public ObjectOutputStream createObjectOutputStream(HierarchicalStreamWriter writer) throws IOException {
        return this.createObjectOutputStream(writer, "object-stream");
    }

    public ObjectOutputStream createObjectOutputStream(Writer writer, String rootNodeName) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(writer), rootNodeName);
    }

    public ObjectOutputStream createObjectOutputStream(OutputStream out) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(out), "object-stream");
    }

    public ObjectOutputStream createObjectOutputStream(OutputStream out, String rootNodeName) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(out), rootNodeName);
    }

    public ObjectOutputStream createObjectOutputStream(HierarchicalStreamWriter writer, String rootNodeName) throws IOException {
        final StatefulWriter statefulWriter = new StatefulWriter(writer);
        statefulWriter.startNode(rootNodeName, null);
        return new CustomObjectOutputStream(new CustomObjectOutputStream.StreamCallback(){

            public void writeToStream(Object object) {
                XStream.this.marshal(object, statefulWriter);
            }

            public void writeFieldsToStream(Map fields) throws NotActiveException {
                throw new NotActiveException("not in call to writeObject");
            }

            public void defaultWriteObject() throws NotActiveException {
                throw new NotActiveException("not in call to writeObject");
            }

            public void flush() {
                statefulWriter.flush();
            }

            public void close() {
                if (statefulWriter.state() != StatefulWriter.STATE_CLOSED) {
                    statefulWriter.endNode();
                    statefulWriter.close();
                }
            }
        });
    }

    public ObjectInputStream createObjectInputStream(Reader xmlReader) throws IOException {
        return this.createObjectInputStream(this.hierarchicalStreamDriver.createReader(xmlReader));
    }

    public ObjectInputStream createObjectInputStream(InputStream in) throws IOException {
        return this.createObjectInputStream(this.hierarchicalStreamDriver.createReader(in));
    }

    public ObjectInputStream createObjectInputStream(final HierarchicalStreamReader reader) throws IOException {
        return new CustomObjectInputStream(new CustomObjectInputStream.StreamCallback(){

            public Object readFromStream() throws EOFException {
                if (!reader.hasMoreChildren()) {
                    throw new EOFException();
                }
                reader.moveDown();
                Object result = XStream.this.unmarshal(reader);
                reader.moveUp();
                return result;
            }

            public Map readFieldsFromStream() throws IOException {
                throw new NotActiveException("not in call to readObject");
            }

            public void defaultReadObject() throws NotActiveException {
                throw new NotActiveException("not in call to readObject");
            }

            public void registerValidation(ObjectInputValidation validation, int priority) throws NotActiveException {
                throw new NotActiveException("stream inactive");
            }

            public void close() {
                reader.close();
            }
        });
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoaderReference.setReference(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoaderReference.getReference();
    }

    public void omitField(Class definedIn, String fieldName) {
        if (this.fieldAliasingMapper == null) {
            throw new InitializationException("No " + FieldAliasingMapper.class.getName() + " available");
        }
        this.fieldAliasingMapper.omitField(definedIn, fieldName);
    }

    public void processAnnotations(Class[] types) {
        if (this.annotationConfiguration == null) {
            throw new InitializationException("No com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.AnnotationMapper available");
        }
        this.annotationConfiguration.processAnnotations(types);
    }

    public void processAnnotations(Class type) {
        this.processAnnotations(new Class[]{type});
    }

    public void autodetectAnnotations(boolean mode) {
        if (this.annotationConfiguration != null) {
            this.annotationConfiguration.autodetectAnnotations(mode);
        }
    }

    private Object readResolve() {
        this.jvm = new JVM();
        return this;
    }

    public static class InitializationException
    extends XStreamException {
        public InitializationException(String message, Throwable cause) {
            super(message, cause);
        }

        public InitializationException(String message) {
            super(message);
        }
    }
}

