/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.collections;

import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.MarshallingContext;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;

public class ArrayConverter
extends AbstractCollectionConverter {
    public ArrayConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return type.isArray();
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        int length = Array.getLength(source);
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(source, i);
            this.writeItem(item, context, writer);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Object> items = new ArrayList<Object>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Object item = this.readItem(reader, context, null);
            items.add(item);
            reader.moveUp();
        }
        Object array = Array.newInstance(context.getRequiredType().getComponentType(), items.size());
        int i = 0;
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            Array.set(array, i++, iterator.next());
        }
        return array;
    }
}

