/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.extended;

import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.ConversionException;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.Converter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.MarshallingContext;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.DynamicProxyMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;

public class DynamicProxyConverter
implements Converter {
    private ClassLoader classLoader;
    private Mapper mapper;

    public DynamicProxyConverter(Mapper mapper) {
        this(mapper, DynamicProxyConverter.class.getClassLoader());
    }

    public DynamicProxyConverter(Mapper mapper, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.mapper = mapper;
    }

    public boolean canConvert(Class type) {
        return type.equals(DynamicProxyMapper.DynamicProxy.class) || Proxy.isProxyClass(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(source);
        this.addInterfacesToXml(source, writer);
        writer.startNode("handler");
        String attributeName = this.mapper.aliasForSystemAttribute("class");
        if (attributeName != null) {
            writer.addAttribute(attributeName, this.mapper.serializedClass(invocationHandler.getClass()));
        }
        context.convertAnother(invocationHandler);
        writer.endNode();
    }

    private void addInterfacesToXml(Object source, HierarchicalStreamWriter writer) {
        Class<?>[] interfaces = source.getClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> currentInterface = interfaces[i];
            writer.startNode("interface");
            writer.setValue(this.mapper.serializedClass(currentInterface));
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        InvocationHandler handler = null;
        while (reader.hasMoreChildren()) {
            String attributeName;
            reader.moveDown();
            String elementName = reader.getNodeName();
            if (elementName.equals("interface")) {
                interfaces.add(this.mapper.realClass(reader.getValue()));
            } else if (elementName.equals("handler") && (attributeName = this.mapper.aliasForSystemAttribute("class")) != null) {
                Class handlerType = this.mapper.realClass(reader.getAttribute(attributeName));
                handler = (InvocationHandler)context.convertAnother(null, handlerType);
            }
            reader.moveUp();
        }
        if (handler == null) {
            throw new ConversionException("No InvocationHandler specified for dynamic proxy");
        }
        Class[] interfacesAsArray = new Class[interfaces.size()];
        interfaces.toArray(interfacesAsArray);
        return Proxy.newProxyInstance(this.classLoader, interfacesAsArray, handler);
    }
}

