/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.reflection;

import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AbstractAttributedCharacterIteratorAttributeConverter
extends AbstractSingleValueConverter {
    private static final Method getName;
    private final Class type;
    private transient Map attributeMap;
    private transient FieldDictionary fieldDictionary;

    public AbstractAttributedCharacterIteratorAttributeConverter(Class type) {
        this.type = type;
        this.readResolve();
    }

    public boolean canConvert(Class type) {
        return type == this.type;
    }

    public String toString(Object source) {
        AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)source;
        try {
            if (!getName.isAccessible()) {
                getName.setAccessible(true);
            }
            return (String)getName.invoke((Object)attribute, (Object[])null);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException("Cannot get name of AttributedCharacterIterator.Attribute", e);
        }
        catch (InvocationTargetException e) {
            throw new ObjectAccessException("Cannot get name of AttributedCharacterIterator.Attribute", e.getTargetException());
        }
    }

    public Object fromString(String str) {
        return this.attributeMap.get(str);
    }

    private Object readResolve() {
        this.fieldDictionary = new FieldDictionary();
        this.attributeMap = new HashMap();
        Iterator iterator = this.fieldDictionary.fieldsFor(this.type);
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (field.getType() != this.type || !Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object attribute = field.get(null);
                this.attributeMap.put(this.toString(attribute), attribute);
            }
            catch (IllegalAccessException e) {
                throw new ObjectAccessException("Cannot get object of " + field, e);
            }
        }
        return this;
    }

    static {
        try {
            getName = AttributedCharacterIterator.Attribute.class.getDeclaredMethod("getName", null);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError("Missing AttributedCharacterIterator.Attribute.getName()");
        }
    }
}

