/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.core.util;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ObjectIdDictionary {
    private final Map map = new HashMap();
    private volatile int counter;

    public void associateId(Object obj, Object id) {
        this.map.put(new WeakIdWrapper(obj), id);
        ++this.counter;
        this.cleanup();
    }

    public Object lookupId(Object obj) {
        Object id = this.map.get(new IdWrapper(obj));
        ++this.counter;
        return id;
    }

    public boolean containsId(Object item) {
        boolean b = this.map.containsKey(new IdWrapper(item));
        ++this.counter;
        return b;
    }

    public void removeId(Object item) {
        this.map.remove(new IdWrapper(item));
        ++this.counter;
        this.cleanup();
    }

    public int size() {
        return this.map.size();
    }

    private void cleanup() {
        if (this.counter > 10000) {
            this.counter = 0;
            Iterator iterator = this.map.keySet().iterator();
            while (iterator.hasNext()) {
                WeakIdWrapper key = (WeakIdWrapper)iterator.next();
                if (key.get() != null) continue;
                iterator.remove();
            }
        }
    }

    private static class WeakIdWrapper
    implements Wrapper {
        private final int hashCode;
        private final WeakReference ref;

        public WeakIdWrapper(Object obj) {
            this.hashCode = System.identityHashCode(obj);
            this.ref = new WeakReference<Object>(obj);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            return this.get() == ((Wrapper)other).get();
        }

        public String toString() {
            Object obj = this.get();
            return obj == null ? "(null)" : obj.toString();
        }

        public Object get() {
            Object obj = this.ref.get();
            return obj;
        }
    }

    private static class IdWrapper
    implements Wrapper {
        private final Object obj;
        private final int hashCode;

        public IdWrapper(Object obj) {
            this.hashCode = System.identityHashCode(obj);
            this.obj = obj;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            return this.obj == ((Wrapper)other).get();
        }

        public String toString() {
            return this.obj.toString();
        }

        public Object get() {
            return this.obj;
        }
    }

    private static interface Wrapper {
        public int hashCode();

        public boolean equals(Object var1);

        public String toString();

        public Object get();
    }
}

