/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper;

import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.InitializationException;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.annotations.XStreamAlias;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.annotations.XStreamConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.annotations.XStreamConverters;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.annotations.XStreamImplicitCollection;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.annotations.XStreamInclude;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.Converter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.ConverterMatcher;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.ConverterRegistry;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.SingleValueConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.SingleValueConverterWrapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.core.JVM;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.core.util.DependencyInjectionFactory;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.AnnotationConfiguration;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.AttributeMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.ClassAliasingMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.DefaultImplementationsMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.FieldAliasingMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.ImplicitCollectionMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.LocalConversionMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.Mapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.MapperWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMapper
extends MapperWrapper
implements AnnotationConfiguration {
    private boolean locked;
    private final Object[] arguments;
    private final ConverterRegistry converterRegistry;
    private final ClassAliasingMapper classAliasingMapper;
    private final DefaultImplementationsMapper defaultImplementationsMapper;
    private final ImplicitCollectionMapper implicitCollectionMapper;
    private final FieldAliasingMapper fieldAliasingMapper;
    private final AttributeMapper attributeMapper;
    private final LocalConversionMapper localConversionMapper;
    private final Map<Class<?>, Converter> converterCache = new HashMap();
    private final Set<Class<?>> annotatedTypes = new WeakHashSet();

    public AnnotationMapper(Mapper wrapped, ConverterRegistry converterRegistry, ClassLoader classLoader, ReflectionProvider reflectionProvider, JVM jvm) {
        super(wrapped);
        this.converterRegistry = converterRegistry;
        this.annotatedTypes.add(Object.class);
        this.classAliasingMapper = (ClassAliasingMapper)this.lookupMapperOfType(ClassAliasingMapper.class);
        this.defaultImplementationsMapper = (DefaultImplementationsMapper)this.lookupMapperOfType(DefaultImplementationsMapper.class);
        this.implicitCollectionMapper = (ImplicitCollectionMapper)this.lookupMapperOfType(ImplicitCollectionMapper.class);
        this.fieldAliasingMapper = (FieldAliasingMapper)this.lookupMapperOfType(FieldAliasingMapper.class);
        this.attributeMapper = (AttributeMapper)this.lookupMapperOfType(AttributeMapper.class);
        this.localConversionMapper = (LocalConversionMapper)this.lookupMapperOfType(LocalConversionMapper.class);
        this.locked = true;
        this.arguments = new Object[]{this, classLoader, reflectionProvider, jvm};
    }

    @Override
    public String realMember(Class type, String serialized) {
        if (!this.locked) {
            this.processAnnotations(type);
        }
        return super.realMember(type, serialized);
    }

    @Override
    public String serializedClass(Class type) {
        if (!this.locked) {
            this.processAnnotations(type);
        }
        return super.serializedClass(type);
    }

    @Override
    public Class defaultImplementationOf(Class type) {
        if (!this.locked) {
            this.processAnnotations(type);
        }
        Class defaultImplementation = super.defaultImplementationOf(type);
        if (!this.locked) {
            this.processAnnotations(defaultImplementation);
        }
        return defaultImplementation;
    }

    @Override
    public Converter getLocalConverter(Class definedIn, String fieldName) {
        if (!this.locked) {
            this.processAnnotations(definedIn);
        }
        return super.getLocalConverter(definedIn, fieldName);
    }

    @Override
    public void autodetectAnnotations(boolean mode) {
        this.locked = !mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAnnotations(Class[] initialTypes) {
        if (initialTypes == null || initialTypes.length == 0) {
            return;
        }
        this.locked = true;
        Set<Class<?>> set = this.annotatedTypes;
        synchronized (set) {
            UnprocessedTypesSet types = new UnprocessedTypesSet();
            for (Class initialType : initialTypes) {
                types.add(initialType);
            }
            this.processTypes(types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAnnotations(Class initialType) {
        if (initialType == null) {
            return;
        }
        Set<Class<?>> set = this.annotatedTypes;
        synchronized (set) {
            UnprocessedTypesSet types = new UnprocessedTypesSet();
            types.add(initialType);
            this.processTypes(types);
        }
    }

    private void processTypes(Set<Class<?>> types) {
        while (!types.isEmpty()) {
            Iterator<Class<?>> iter = types.iterator();
            Class<?> type = iter.next();
            iter.remove();
            if (!this.annotatedTypes.add(type) || type.isPrimitive()) continue;
            this.addParametrizedTypes(type, types);
            this.processConverterAnnotations(type);
            this.processAliasAnnotation(type, types);
            if (type.isInterface()) continue;
            this.processImplicitCollectionAnnotation(type);
            Field[] fields = type.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (field.isEnumConstant() || (field.getModifiers() & 0x88) > 0) continue;
                this.addParametrizedTypes(field.getGenericType(), types);
                if (field.isSynthetic()) continue;
                this.processFieldAliasAnnotation(field);
                this.processAsAttributeAnnotation(field);
                this.processImplicitAnnotation(field);
                this.processOmitFieldAnnotation(field);
                this.processLocalConverterAnnotation(field);
            }
        }
    }

    private void addParametrizedTypes(Type type, final Set<Class<?>> types) {
        final HashSet<Type> processedTypes = new HashSet<Type>();
        LinkedHashSet<Type> localTypes = new LinkedHashSet<Type>(){

            @Override
            public boolean add(Type o) {
                if (o instanceof Class) {
                    return types.add((Class)o);
                }
                return o == null || processedTypes.contains(o) ? false : super.add(o);
            }
        };
        while (type != null) {
            processedTypes.add(type);
            if (type instanceof Class) {
                Class clazz = (Class)type;
                types.add(clazz);
                if (!clazz.isPrimitive()) {
                    TypeVariable<Class<T>>[] typeParameters = clazz.getTypeParameters();
                    for (Type type2 : typeParameters) {
                        localTypes.add(type2);
                    }
                    localTypes.add(clazz.getGenericSuperclass());
                    for (Type type3 : clazz.getGenericInterfaces()) {
                        localTypes.add(type3);
                    }
                }
            } else if (type instanceof TypeVariable) {
                Type[] bounds;
                TypeVariable typeVariable = (TypeVariable)type;
                for (Type type4 : bounds = typeVariable.getBounds()) {
                    localTypes.add(type4);
                }
            } else if (type instanceof ParameterizedType) {
                ParameterizedType parametrizedType = (ParameterizedType)type;
                localTypes.add(parametrizedType.getRawType());
                Type[] actualArguments = parametrizedType.getActualTypeArguments();
                for (Type type5 : actualArguments) {
                    localTypes.add(type5);
                }
            } else if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type;
                localTypes.add(arrayType.getGenericComponentType());
            }
            if (!localTypes.isEmpty()) {
                Iterator iter = localTypes.iterator();
                type = (Type)iter.next();
                iter.remove();
                continue;
            }
            type = null;
        }
    }

    private void processConverterAnnotations(Class<?> type) {
        if (this.converterRegistry != null) {
            ArrayList<XStreamConverter> annotations;
            XStreamConverters convertersAnnotation = type.getAnnotation(XStreamConverters.class);
            XStreamConverter converterAnnotation = type.getAnnotation(XStreamConverter.class);
            ArrayList<XStreamConverter> arrayList = annotations = convertersAnnotation != null ? new ArrayList<XStreamConverter>(Arrays.asList(convertersAnnotation.value())) : new ArrayList();
            if (converterAnnotation != null) {
                annotations.add(converterAnnotation);
            }
            for (XStreamConverter annotation : annotations) {
                Class<? extends ConverterMatcher> converterType = annotation.value();
                Converter converter = this.cacheConverter(converterType);
                if (converter == null) continue;
                if (converterAnnotation != null || converter.canConvert(type)) {
                    this.converterRegistry.registerConverter(converter, 0);
                    continue;
                }
                throw new InitializationException("Converter " + converterType.getName() + " cannot handle annotated class " + type.getName());
            }
        }
    }

    private void processAliasAnnotation(Class<?> type, Set<Class<?>> types) {
        XStreamAlias aliasAnnotation = type.getAnnotation(XStreamAlias.class);
        if (aliasAnnotation != null) {
            if (this.classAliasingMapper == null) {
                throw new InitializationException("No " + ClassAliasingMapper.class.getName() + " available");
            }
            if (aliasAnnotation.impl() != Void.class) {
                this.classAliasingMapper.addClassAlias(aliasAnnotation.value(), type);
                this.defaultImplementationsMapper.addDefaultImplementation(aliasAnnotation.impl(), type);
                if (type.isInterface()) {
                    types.add(aliasAnnotation.impl());
                }
            } else {
                this.classAliasingMapper.addClassAlias(aliasAnnotation.value(), type);
            }
        }
    }

    @Deprecated
    private void processImplicitCollectionAnnotation(Class<?> type) {
        XStreamImplicitCollection implicitColAnnotation = type.getAnnotation(XStreamImplicitCollection.class);
        if (implicitColAnnotation != null) {
            Field field;
            if (this.implicitCollectionMapper == null) {
                throw new InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
            }
            String fieldName = implicitColAnnotation.value();
            String itemFieldName = implicitColAnnotation.item();
            try {
                field = type.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new InitializationException(type.getName() + " does not have a field named '" + fieldName + "' as required by " + XStreamImplicitCollection.class.getName());
            }
            Class<?> itemType = null;
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                Type typeArgument = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                itemType = this.getClass(typeArgument);
            }
            if (itemType == null) {
                this.implicitCollectionMapper.add(type, fieldName, null, Object.class);
            } else if (itemFieldName.equals("")) {
                this.implicitCollectionMapper.add(type, fieldName, null, itemType);
            } else {
                this.implicitCollectionMapper.add(type, fieldName, itemFieldName, itemType);
            }
        }
    }

    private void processFieldAliasAnnotation(Field field) {
        XStreamAlias aliasAnnotation = field.getAnnotation(XStreamAlias.class);
        if (aliasAnnotation != null) {
            if (this.fieldAliasingMapper == null) {
                throw new InitializationException("No " + FieldAliasingMapper.class.getName() + " available");
            }
            this.fieldAliasingMapper.addFieldAlias(aliasAnnotation.value(), field.getDeclaringClass(), field.getName());
        }
    }

    private void processAsAttributeAnnotation(Field field) {
        XStreamAsAttribute asAttributeAnnotation = field.getAnnotation(XStreamAsAttribute.class);
        if (asAttributeAnnotation != null) {
            if (this.attributeMapper == null) {
                throw new InitializationException("No " + AttributeMapper.class.getName() + " available");
            }
            this.attributeMapper.addAttributeFor(field);
        }
    }

    private void processImplicitAnnotation(Field field) {
        XStreamImplicit implicitAnnotation = field.getAnnotation(XStreamImplicit.class);
        if (implicitAnnotation != null) {
            if (this.implicitCollectionMapper == null) {
                throw new InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
            }
            String fieldName = field.getName();
            String itemFieldName = implicitAnnotation.itemFieldName();
            Class<?> itemType = null;
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                Type typeArgument = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                itemType = this.getClass(typeArgument);
            }
            if (itemFieldName != null && !"".equals(itemFieldName)) {
                this.implicitCollectionMapper.add(field.getDeclaringClass(), fieldName, itemFieldName, itemType);
            } else {
                this.implicitCollectionMapper.add(field.getDeclaringClass(), fieldName, itemType);
            }
        }
    }

    private void processOmitFieldAnnotation(Field field) {
        XStreamOmitField omitFieldAnnotation = field.getAnnotation(XStreamOmitField.class);
        if (omitFieldAnnotation != null) {
            if (this.fieldAliasingMapper == null) {
                throw new InitializationException("No " + FieldAliasingMapper.class.getName() + " available");
            }
            this.fieldAliasingMapper.omitField(field.getDeclaringClass(), field.getName());
        }
    }

    private void processLocalConverterAnnotation(Field field) {
        Class<? extends ConverterMatcher> converterType;
        Converter converter;
        XStreamConverter annotation = field.getAnnotation(XStreamConverter.class);
        if (annotation != null && (converter = this.cacheConverter(converterType = annotation.value())) != null) {
            if (this.localConversionMapper == null) {
                throw new InitializationException("No " + LocalConversionMapper.class.getName() + " available");
            }
            this.localConversionMapper.registerLocalConverter(field.getDeclaringClass(), field.getName(), converter);
        }
    }

    private Converter cacheConverter(Class<? extends ConverterMatcher> converterType) {
        Converter converter = this.converterCache.get(converterType);
        if (converter == null) {
            try {
                if (SingleValueConverter.class.isAssignableFrom(converterType)) {
                    SingleValueConverter svc = (SingleValueConverter)DependencyInjectionFactory.newInstance(converterType, this.arguments);
                    converter = new SingleValueConverterWrapper(svc);
                } else {
                    converter = (Converter)DependencyInjectionFactory.newInstance(converterType, this.arguments);
                }
                this.converterCache.put(converterType, converter);
            }
            catch (Exception e) {
                throw new InitializationException("Cannot instantiate converter " + converterType.getName(), e);
            }
        }
        return converter;
    }

    private Class<?> getClass(Type typeArgument) {
        Class type = null;
        if (typeArgument instanceof ParameterizedType) {
            type = (Class)((ParameterizedType)typeArgument).getRawType();
        } else if (typeArgument instanceof Class) {
            type = (Class)typeArgument;
        }
        return type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakHashSet<K>
    implements Set<K> {
        private static Object NULL = new Object();
        private final WeakHashMap<K, Object> map = new WeakHashMap();

        private WeakHashSet() {
        }

        @Override
        public boolean add(K o) {
            return this.map.put(o, NULL) == null;
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            boolean ret = false;
            for (K k : c) {
                ret = this.add(k) | false;
            }
            return ret;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.map.keySet().containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) != null;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean ret = false;
            for (Object object : c) {
                ret = this.remove(object) | false;
            }
            return ret;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean ret = false;
            Iterator<K> iter = this.iterator();
            while (iter.hasNext()) {
                K element = iter.next();
                if (c.contains(element)) continue;
                iter.remove();
                ret = true;
            }
            return ret;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Object[] toArray() {
            return this.map.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.map.keySet().toArray(a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UnprocessedTypesSet
    extends LinkedHashSet<Class<?>> {
        private UnprocessedTypesSet() {
        }

        @Override
        public boolean add(Class<?> type) {
            Class<?>[] incTypes;
            XStreamInclude inc;
            boolean ret;
            if (type == null) {
                return false;
            }
            while (type.isArray()) {
                type = type.getComponentType();
            }
            String name = type.getName();
            if (name.startsWith("java.") || name.startsWith("javax.")) {
                return false;
            }
            boolean bl = ret = AnnotationMapper.this.annotatedTypes.contains(type) ? false : super.add(type);
            if (ret && (inc = type.getAnnotation(XStreamInclude.class)) != null && (incTypes = inc.value()) != null) {
                for (Class<?> incType : incTypes) {
                    this.add(incType);
                }
            }
            return ret;
        }
    }
}

