/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper;

import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.Mapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.MapperWrapper;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CachingMapper
extends MapperWrapper {
    private transient Map realClassCache;

    public CachingMapper(Mapper wrapped) {
        super(wrapped);
        this.readResolve();
    }

    public Class realClass(String elementName) {
        Class cached;
        WeakReference reference = (WeakReference)this.realClassCache.get(elementName);
        if (reference != null && (cached = (Class)reference.get()) != null) {
            return cached;
        }
        Class result = super.realClass(elementName);
        this.realClassCache.put(elementName, new WeakReference<Class>(result));
        return result;
    }

    private Object readResolve() {
        this.realClassCache = Collections.synchronizedMap(new HashMap(128));
        return this;
    }
}

