/*
 * Decompiled with CFR 0.152.
 */
package com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper;

import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.ConverterLookup;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.SingleValueConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.converters.enums.EnumSingleValueConverter;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.AttributeMapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.Mapper;
import com.xuanwu.mos.thirdparty.com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.EnumSet;
import java.util.Map;
import java.util.WeakHashMap;

public class EnumMapper
extends MapperWrapper {
    private transient AttributeMapper attributeMapper;
    private transient Map enumConverterMap;
    private final ConverterLookup converterLookup;

    public EnumMapper(Mapper wrapped, ConverterLookup lookup) {
        super(wrapped);
        this.converterLookup = lookup;
        this.readResolve();
    }

    @Deprecated
    public EnumMapper(Mapper wrapped) {
        super(wrapped);
        this.converterLookup = null;
        this.readResolve();
    }

    public String serializedClass(Class type) {
        if (type == null) {
            return super.serializedClass(type);
        }
        if (Enum.class.isAssignableFrom(type) && type.getSuperclass() != Enum.class) {
            return super.serializedClass(type.getSuperclass());
        }
        if (EnumSet.class.isAssignableFrom(type)) {
            return super.serializedClass(EnumSet.class);
        }
        return super.serializedClass(type);
    }

    public boolean isImmutableValueType(Class type) {
        return Enum.class.isAssignableFrom(type) || super.isImmutableValueType(type);
    }

    public SingleValueConverter getConverterFromItemType(String fieldName, Class type, Class definedIn) {
        SingleValueConverter converter = this.getLocalConverter(fieldName, type, definedIn);
        return converter == null ? super.getConverterFromItemType(fieldName, type, definedIn) : converter;
    }

    public SingleValueConverter getConverterFromAttribute(Class definedIn, String attribute, Class type) {
        SingleValueConverter converter = this.getLocalConverter(attribute, type, definedIn);
        return converter == null ? super.getConverterFromAttribute(definedIn, attribute, type) : converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingleValueConverter getLocalConverter(String fieldName, Class type, Class definedIn) {
        if (this.attributeMapper != null && Enum.class.isAssignableFrom(type) && this.attributeMapper.shouldLookForSingleValueConverter(fieldName, type, definedIn)) {
            Map map = this.enumConverterMap;
            synchronized (map) {
                SingleValueConverter singleValueConverter = (SingleValueConverter)this.enumConverterMap.get(type);
                if (singleValueConverter == null) {
                    singleValueConverter = super.getConverterFromItemType(fieldName, type, definedIn);
                    if (singleValueConverter == null) {
                        singleValueConverter = new EnumSingleValueConverter(type);
                    }
                    this.enumConverterMap.put(type, singleValueConverter);
                }
                return singleValueConverter;
            }
        }
        return null;
    }

    private Object readResolve() {
        this.enumConverterMap = new WeakHashMap();
        this.attributeMapper = (AttributeMapper)this.lookupMapperOfType(AttributeMapper.class);
        return this;
    }
}

